import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET() {
  try {
    const [attendance] = await db.query('SELECT * FROM attendance ORDER BY date DESC, class, studentName');
    return json({ success: true, data: attendance });
  } catch (error) {
    console.error('Get attendance error:', error);
    return json({ error: 'Gagal mengambil data kehadiran' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function POST({ request }) {
  try {
    const data = await request.json();
    const { studentId, studentName, class: className, date, status, subject, teacher } = data;

    if (!studentId || !date || !status) {
      return json({ error: 'ID Siswa, Tanggal, dan Status wajib diisi' }, { status: 400 });
    }

    const [result] = await db.query(
      `INSERT INTO attendance (studentId, studentName, class, date, status, subject, teacher)
       VALUES (?, ?, ?, ?, ?, ?, ?)`,
      [
        studentId,
        studentName || null,
        className || null,
        date,
        status.trim(),
        subject || null,
        teacher || null
      ]
    );

    return json({
      success: true,
      message: 'Data kehadiran berhasil ditambahkan',
      data: { id: result.insertId, ...data }
    });
  } catch (error) {
    console.error('Create attendance error:', error);
    return json({ error: 'Gagal menambahkan data kehadiran' }, { status: 500 });
  }
}
