import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET() {
  try {
    const [classes] = await db.query('SELECT * FROM classes ORDER BY name');
    return json({ success: true, data: classes });
  } catch (error) {
    console.error('Get classes error:', error);
    return json({ error: 'Gagal mengambil data kelas' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function POST({ request }) {
  try {
    const data = await request.json();
    const { name, major, homeroomTeacher, studentCount, status } = data;

    if (!name) {
      return json({ error: 'Nama kelas wajib diisi' }, { status: 400 });
    }

    const [result] = await db.query(
      `INSERT INTO classes (name, major, homeroomTeacher, studentCount, status)
       VALUES (?, ?, ?, ?, ?)`,
      [name.trim(), major || null, homeroomTeacher || null, studentCount || 0, status || 'aktif']
    );

    return json({
      success: true,
      message: 'Kelas berhasil ditambahkan',
      data: { id: result.insertId, ...data }
    });
  } catch (error) {
    console.error('Create class error:', error);
    return json({ error: 'Gagal menambahkan kelas' }, { status: 500 });
  }
}
