import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET() {
  try {
    const [students] = await db.query('SELECT * FROM students ORDER BY class, fullName');
    return json({ success: true, data: students });
  } catch (error) {
    console.error('Get students error:', error);
    return json({ error: 'Gagal mengambil data siswa' }, { status: 500 });
  }
}
