import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET() {
  try {
    const [teachers] = await db.query('SELECT * FROM teachers ORDER BY fullName');
    return json({ success: true, data: teachers });
  } catch (error) {
    console.error('Get teachers error:', error);
    return json({ error: 'Gagal mengambil data guru' }, { status: 500 });
  }
}
